// *********************************************************************
// macros.h
//
// マクロ定義
//
// $Id: macros.h,v 1.4 2004/05/13 03:14:19 Furusawa Exp $
// *********************************************************************

#ifndef _MACROS_H_
#define _MACROS_H_

#pragma __once


// =====================================================================
// 定数・置換・計算など（パラメータとして使用可能）
// ---------------------------------------------------------------------
// キャラ・ＢＧの表示位置
#define POS0	SC_CHRPOS_X0	// キャラ表示位置０（左）
#define POS1	SC_CHRPOS_X1	// キャラ表示位置１（左中）
#define POS2	SC_CHRPOS_X2	// キャラ表示位置２（中）
#define POS3	SC_CHRPOS_X3	// キャラ表示位置３（右中）
#define POS4	SC_CHRPOS_X4	// キャラ表示位置４（右）
#define POS_L	SC_CHRPOS_X0	// キャラ表示位置０（左）
#define POS_LC	SC_CHRPOS_X1	// キャラ表示位置１（左中）
#define POS_C	SC_CHRPOS_X2	// キャラ表示位置２（中）
#define POS_RC	SC_CHRPOS_X3	// キャラ表示位置３（右中）
#define POS_R	SC_CHRPOS_X4	// キャラ表示位置４（右）
#define POS_Y	SC_CHRPOS_Y		// キャラ表示位置（Ｙ座標）
#define POS_Z	90				// キャラ表示位置（Ｙ座標）
// キャラボイスのパンポット
#define PAN0	SC_CHAPAN_X0	// キャラボイスのパンポット（左）
#define PAN1	SC_CHAPAN_X1	// キャラボイスのパンポット（左中）
#define PAN2	SC_CHAPAN_X2	// キャラボイスのパンポット（中）
#define PAN3	SC_CHAPAN_X3	// キャラボイスのパンポット（右中）
#define PAN4	SC_CHAPAN_X4	// キャラボイスのパンポット（右）
#define PAN_L	SC_CHAPAN_X0	// キャラボイスのパンポット（左）
#define PAN_LC	SC_CHAPAN_X1	// キャラボイスのパンポット（左中）
#define PAN_C	SC_CHAPAN_X2	// キャラボイスのパンポット（中）
#define PAN_RC	SC_CHAPAN_X3	// キャラボイスのパンポット（右中）
#define PAN_R	SC_CHAPAN_X4	// キャラボイスのパンポット（右）

// カラー指定（(A)RGB値を 0-255 の範囲で指定）カラー指定するコマンド全般で使用
#define RGB(r, g, b)	(((r) * 65536) + ((g) * 256) + b)
#define ARGB(a, r, g, b)	(((a) * 16777216) + ((r) * 65536) + ((g) * 256) + b)
#define RGBA(r, g, b, a)	(((a) * 16777216) + ((r) * 65536) + ((g) * 256) + b)
// =====================================================================


// =====================================================================
// 旧コマンドや移行中のコマンドとの互換性を維持するための定義
// ---------------------------------------------------------------------
// ワーク関連のコマンド
#define Work_Set(no, val)		ScrWork_Set(no, val)
#define Work_Add(no, val)		ScrWork_Add(no, val)
#define Work_Sub(no, val)		ScrWork_Sub(no, val)
#define Work_Mul(no, val)		ScrWork_Mul(no, val)
#define Work_Div(no, val)		ScrWork_Div(no, val)
#define Work_Sur(no, val)		ScrWork_Sur(no, val)
#define Work_And(no, val)		ScrWork_And(no, val)
#define Work_Or(no, val)		ScrWork_Or(no, val)
#define Work_Not(no, val)		ScrWork_Not(no, val)
#define Work_Eor(no, val)		ScrWork_Eor(no, val)
#define Work_BitSet(no, bit)	ScrWork_BitSet(no, bit)
#define Work_BitRst(no, bit)	ScrWork_BitRst(no, bit)
// ---------------------------------------------------------------------
// 条件分岐
#define if_Work_Eq(no, val)		if_ScrWork_Eq(no, val)
#define if_Work_Ne(no, val)		if_ScrWork_Ne(no, val)
#define if_Work_Lt(no, val)		if_ScrWork_Lt(no, val)
#define if_Work_Le(no, val)		if_ScrWork_Le(no, val)
#define if_Work_Gt(no, val)		if_ScrWork_Gt(no, val)
#define if_Work_Ge(no, val)		if_ScrWork_Ge(no, val)
#define if_Work_EqA(no1, no2)	if_ScrWork_Eq(no1, no2)
#define if_Work_NeA(no1, no2)	if_ScrWork_Ne(no1, no2)
#define if_Work_LtA(no1, no2)	if_ScrWork_Lt(no1, no2)
#define if_Work_LeA(no1, no2)	if_ScrWork_Le(no1, no2)
#define if_Work_GtA(no1, no2)	if_ScrWork_Gt(no1, no2)
#define if_Work_GeA(no1, no2)	if_ScrWork_Ge(no1, no2)
#define if_Work_BitSet(no, bit)	if_ScrWork_BitSet(no, bit)
#define if_Work_BitRst(no, bit)	if_ScrWork_BitRst(no, bit)
// ---------------------------------------------------------------------
// 複数の分岐
#define Work_Switch(no)			ScrWork_Switch(no)
// =====================================================================


// =====================================================================
// 振動
// ---------------------------------------------------------------------
// パッドの振動を追加
#define WIN_WAVE(type, max, time)	\
		Win_Wave(0, type, max, time)	\
		Win_Wave(1, type, max, time)	\
		PadWave(max*16, 0, time*2)

#define WIN_WAVESTOP()	\
		Win_WaveStop(0)	\
		Win_WaveStop(1)	\
		PadWaveStop()

#define BG_WAVE(no, type, max, time)	\
		Bg_Wave(no, type, max, time)	\
		PadWave(max*16, 0, time*2)

#define BG_WAVESTOP(no)		\
		Bg_WaveStop(no)		\
		PadWaveStop()

#define CHA_WAVE(no, type, max, time)	\
		Cha_Wave(no, type, max, time)

#define CHA_WAVESTOP(no)		\
		Cha_WaveStop(no)
// =====================================================================


// =====================================================================
// 全体フェード
// ---------------------------------------------------------------------
// フェードイン
#define FADE_IN_NW(effect, time)	\
		Fade_In(effect, time)

#define FADE_IN(effect, time)		\
		Fade_In(effect, time)		\
		Fade_Wait()
// ---------------------------------------------------------------------
// αフェードイン
#define A_FADE_IN_NW(file, pal, time)	\
		AlphaFade_In(file, pal, time)

#define A_FADE_IN(file, pal, time)		\
		AlphaFade_In(file, pal, time)	\
		Fade_Wait()
// ---------------------------------------------------------------------
// カラー指定フェードアウト（フェードインはFADE_INでＯＫ）
#define FADE_OUT_COLOR_NW(effect, time, color)	\
		Fade_Color(color)						\
		Fade_Out(effect, time)

#define FADE_OUT_COLOR(effect, time, color)		\
		FADE_OUT_COLOR_NW(effect, time, color)	\
		Fade_Wait()
// ---------------------------------------------------------------------
// フェードアウト
#define FADE_OUT_NW(effect, time)	FADE_OUT_COLOR_NW(effect, time, 0x0)
#define FADE_OUT(effect, time)		FADE_OUT_COLOR(effect, time, 0x0)
// ---------------------------------------------------------------------
// αフェードアウト
#define A_FADE_OUT_NW(file, pal, time)	\
		AlphaFade_Out(file, pal, time)

#define A_FADE_OUT(file, pal, time)		\
		AlphaFade_Out(file, pal, time)	\
		Fade_Wait()
// ---------------------------------------------------------------------
// ホワイトアウト
#define WHITE_OUT_NW(effect, time)	FADE_OUT_COLOR_NW(effect, time, RGB(255,255,255))
#define WHITE_OUT(effect, time)		FADE_OUT_COLOR(effect, time, RGB(255,255,255))
// ホワイトインはFADE_INでＯＫ（一応互換性のために定義）
#define WHITE_IN_NW(effect, time)	FADE_IN_NW(effect, time)
#define WHITE_IN(effect, time)		FADE_IN(effect, time)
// ---------------------------------------------------------------------
// 終了待ち
#define FADE_WAIT()		Fade_Wait()
// =====================================================================


// =====================================================================
// 消去
// ---------------------------------------------------------------------
// 全てのＢＧ・キャラ・ウィンドウを非表示にします
#define ALL_CLEAR()					\
		Bg_Show(0, 0)				\
		Bg_Show(1, 0)				\
		Bg_Show(2, 0)				\
		Win_Show(0, 0)				\
		Win_Show(1, 0)				\
		Win_Show(2, 0)				\
		Win_MesClear(0)				\
		Win_MesClear(1)				\
		Win_MesClear(2)				\
		Cha_Show(0, 0)				\
		Cha_Show(1, 0)				\
		Cha_Show(2, 0)				\
		Cha_Show(3, 0)				\
		Cha_Show(4, 0)				\
		Cha_Show(5, 0)				\
		Cha_Show(6, 0)				\
		Cha_Show(7, 0)				\
		Cha_Show(8, 0)
// =====================================================================


// =====================================================================
// ウィンドウ・選択肢
// ---------------------------------------------------------------------
// ウィンドウの表示
#define WIN_SHOW()			\
		Win_MesClear(0)		\
		Win_Show(0,1)
// ---------------------------------------------------------------------
// ウィンドウをフェードイン
#define WIN_FADEIN_NW(time)		\
		Win_MesClear(0)			\
		Win_FadeIn(0, 0, time)

#define WIN_FADEIN(time)		\
		WIN_FADEIN_NW(time)		\
		Win_Wait(0)
// ---------------------------------------------------------------------
// ウィンドウを消す
#define WIN_CLEAR()			\
		Win_Show(0, 0)		\
		Win_Show(1, 0)		\
		Win_MesClear(0)		\
		Win_MesClear(1)
// ---------------------------------------------------------------------
// ウィンドウをフェードアウト
#define WIN_FADEOUT_NW(time)	\
		Win_FadeOut(0, 0, time)	\
		Win_FadeOut(1, 0, time)

#define WIN_FADEOUT(time)		\
		WIN_FADEOUT_NW(time)	\
		Win_Wait(0)				\
		Win_MesClear(0)			\
		Win_MesClear(1)
// ---------------------------------------------------------------------
// メッセージの表示（名前ウィンドウなし）
#define WIN_MES()			\
		Win_Show(1, 0)		\
		Win_MesClear(1)		\
		Win_Mes3(0)
// ---------------------------------------------------------------------
// メッセージの表示（名前表示）
#define WIN_MES_N(name)		\
		Win_Show(1, 1)		\
		Win_Mes(1){			\
		name				\
		}					\
		Win_Mes3(0)
// ---------------------------------------------------------------------
// メッセージとボイスの同時指定
#define WIN_MES_V(name, no, pan, file)	\
		Win_MesChain(0, no)				\
		VOICE_Pan(pan, 0)				\
		VOICE_Play(file)				\
		Win_Show(1, 1)					\
		Win_Mes(1){						\
		name							\
		}								\
		Win_Mes3(0)
// ---------------------------------------------------------------------
// 選択肢表示（選択肢用のウィンドウ（２番）から取得）
#define WIN_SELECT()					\
		Win_Select(2)
// ---------------------------------------------------------------------
// 直前の選択肢の内容で分岐（選択肢用のウィンドウ（２番）から取得）
#define SWITCH()						\
		ScrWin_GetSel(2, SUW_RESULT)	\
		ScrWork_Switch(SUW_RESULT)
// =====================================================================


// =====================================================================
// フラグ（ビット単位でアクセスできるワーク）管理
// ---------------------------------------------------------------------
// フラグＯＮ
#define FLAG_ON(no)			ScrWork_BitSet(SUF_FLAG_BEGIN, no)
// システムフラグＯＮ
#define SYS_FLAG_ON(no)		ScrWork_BitSet(SSF_FLAG_BEGIN, no)

// フラグＯＦＦ
#define FLAG_OFF(no)		ScrWork_BitRst(SUF_FLAG_BEGIN, no)
// システムフラグＯＦＦ
#define SYS_FLAG_OFF(no)	ScrWork_BitRst(SSF_FLAG_BEGIN, no)

// フラグＯＮだったらジャンプ
#define IF_FLAG_ON(no)		if_ScrWork_BitSet(SUF_FLAG_BEGIN, no)
// システムフラグＯＮだったらジャンプ
#define IF_SYS_FLAG_ON(no)	if_ScrWork_BitSet(SSF_FLAG_BEGIN, no)

// フラグＯＦＦだったらジャンプ
#define IF_FLAG_OFF(no)		if_ScrWork_BitRst(SUF_FLAG_BEGIN, no)
// システムフラグＯＦＦだったらジャンプ
#define IF_SYS_FLAG_OFF(no)	if_ScrWork_BitRst(SSF_FLAG_BEGIN, no)
// =====================================================================


// =====================================================================
// ＢＧ管理
// ---------------------------------------------------------------------
// ＢＧをセットして表示
#define BG_SET(no, file, prio)					\
		Bg_Priority(no, prio)					\
		Bg_Set(no, file)						\
		Bg_Show(no, 1)
// ---------------------------------------------------------------------
// ＢＧをセットしてフェードイン
#define BG_FADEIN_NW(no, file, prio, effect, time)	\
		Bg_Set(no, file)							\
		Bg_Priority(no, prio)						\
		Bg_FadeIn(no, effect, time)

#define BG_FADEIN(no, file, prio, effect, time)		\
		BG_FADEIN_NW(no, file, prio, effect, time)	\
		Bg_Wait(no)
// ---------------------------------------------------------------------
// ＢＧをフェードアウト
#define BG_FADEOUT_NW(no, effect, time)			\
		Bg_FadeOut(no, effect, time)

#define BG_FADEOUT(no, effect, time)			\
		BG_FADEOUT_NW(no, effect, time)			\
		Bg_Wait(no)
// ---------------------------------------------------------------------
// ＢＧクロスフェード（実際にはキャラの表情変えと同じ動き）
#define BG_CROSS_FADE_NW(no, file, prio, effect, time, out_no)	\
		Bg_Set(no, file)										\
		Bg_Show(no, 1)											\
		Bg_Priority(out_no, prio-1)								\
		Bg_Priority(no, prio)									\
		Bg_FadeOut(out_no, effect, time)

#define BG_CROSS_FADE(no, file, prio, effect, time, out_no)		\
		BG_CROSS_FADE_NW(no, file, prio, effect, time, out_no)	\
		Bg_Wait(out_no)
// =====================================================================


// =====================================================================
// 表示位置の補足説明
// ---------------------------------------------------------------------
// ┌───────┐ ０…左
// │              │ １…左中
// │              │ ２…中
// │     画面     │ ３…右中
// │              │ ４…右
// └───────┘
// POS0  1  2  3  4
//  L   LC  C  RC  R
//
// POS0, POS1, …, POS4 または POS_L, POS_LC, …, POS_R で指定してください
// POS0+20 とか POS_C-30 などでもＯＫ
// =====================================================================


// =====================================================================
// キャラの表示／非表示
// ---------------------------------------------------------------------
// キャラをセットして表示
#define CHA_SET_XY(no, file, xx, yy, prio)	\
		Cha_Pos(no, xx, yy)					\
		Cha_Priority(no, prio)				\
		Cha_Set(no, file)					\
		Cha_Show(no, 1)
// ---------------------------------------------------------------------
// キャラをセットして表示
#define CHA_SET(no, file, pos, prio)		\
		CHA_SET_XY(no, file, pos, SC_CHRPOS_Y, prio)
// =====================================================================


// =====================================================================
// キャラのフェード
// ---------------------------------------------------------------------
// キャラをセットしてフェードイン
#define CHA_FADEIN_XY_NW(no, file, xx, yy, prio, time)	\
		Cha_Set(no, file)								\
		Cha_Pos(no, xx, yy)								\
		Cha_Priority(no, prio)							\
		Cha_FadeIn(no, 0, time)

#define CHA_FADEIN_XY(no, file, xx, yy, prio, time)		\
		CHA_FADEIN_XY_NW(no, file, xx, yy, prio, time)	\
		Cha_Wait(no)
// ---------------------------------------------------------------------
// キャラをセットしてフェードイン
#define CHA_FADEIN_NW(no, file, pos, prio, time)		\
		CHA_FADEIN_XY_NW(no, file, pos, SC_CHRPOS_Y, prio, time)

#define CHA_FADEIN(no, file, pos, prio, time)		\
		CHA_FADEIN_XY(no, file, pos, SC_CHRPOS_Y, prio, time)
// ---------------------------------------------------------------------
// キャラをフェードアウト
#define CHA_FADEOUT_NW(no, time)	\
		Cha_FadeOut(no, 0, time)

#define CHA_FADEOUT(no, time)		\
		CHA_FADEOUT_NW(no, time)	\
		Cha_Wait(no)
// =====================================================================


// =====================================================================
// クロスフェード（ポーズ変え）
// ---------------------------------------------------------------------
// キャラのクロスフェード
#define CHA_CROSS_FADE_XY_NW(no, file, xx, yy, prio, time, out_no)	\
		Cha_Set(no, file)											\
		Cha_Pos(no, xx, yy)											\
		Cha_Priority(no, prio)										\
		Cha_FadeOut(out_no, 0, time)								\
		Cha_FadeIn(no, 0, time)

#define CHA_CROSS_FADE_XY(no, file, xx, yy, prio, time, out_no)		\
		CHA_CROSS_FADE_XY_NW(no, file, xx, yy, prio, time, out_no)	\
		Cha_Wait(no)
// ---------------------------------------------------------------------
// キャラのクロスフェード
#define CHA_CROSS_FADE_NW(no, file, pos, prio, time, out_no)		\
		CHA_CROSS_FADE_XY_NW(no, file, pos, SC_CHRPOS_Y, prio, time, out_no)

#define CHA_CROSS_FADE(no, file, pos, prio, time, out_no)			\
		CHA_CROSS_FADE_XY(no, file, pos, SC_CHRPOS_Y, prio, time, out_no)
// =====================================================================


// =====================================================================
// キャラの表情変え
// ---------------------------------------------------------------------
// 表情変え
#define CHA_CHANGE_FACE_XY_NW(no, file, xx, yy, prio, time, out_no)	\
		Cha_Priority(out_no, prio-1)								\
		Cha_Pos(no, xx, yy,)											\
		Cha_Priority(no, prio)										\
		Cha_Set(no, file)											\
		Cha_Show(no, 1)												\
		Cha_FadeOut(out_no, 0, time)

#define CHA_CHANGE_FACE_XY(no, file, xx, yy, prio, time, out_no)		\
		CHA_CHANGE_FACE_XY_NW(no, file, xx, yy, prio, time, out_no)	\
		Cha_Wait(out_no)
// ---------------------------------------------------------------------
// 表情変え
#define CHA_CHANGE_FACE_NW(no, file, pos, prio, time, out_no)		\
		CHA_CHANGE_FACE_XY_NW(no, file, pos, SC_CHRPOS_Y, prio, time, out_no)

#define CHA_CHANGE_FACE(no, file, pos, prio, time, out_no)			\
		CHA_CHANGE_FACE_XY(no, file, pos, SC_CHRPOS_Y, prio, time, out_no)
// =====================================================================


// =====================================================================
// 複数キャラの同時フェードイン
// ---------------------------------------------------------------------
// ２キャラをセットしてフェードイン
#define CHA_FADEIN_2_XY_NW(no0, file0, x0, y0, prio0, no1, file1, x1, y1, prio1, time)	\
		Cha_Set(no0, file0)			\
		Cha_Set(no1, file1)			\
		Cha_Pos(no0, x0, y0)		\
		Cha_Pos(no1, x1, y1)		\
		Cha_Priority(no0, prio0)	\
		Cha_Priority(no1, prio1)	\
		Cha_FadeIn(no0, 0, time)	\
		Cha_FadeIn(no1, 0, time)

#define CHA_FADEIN_2_XY(no0, file0, x0, y0, prio0, no1, file1, x1, y1, prio1, time)		\
		CHA_FADEIN_2_XY_NW(no0, file0, x0, y0, prio0, no1, file1, x1, y1, prio1, time)	\
		Cha_Wait(no0)
// ---------------------------------------------------------------------
// ２キャラをセットしてフェードイン
#define CHA_FADEIN_2_NW(no0, file0, pos0, prio0, no1, file1, pos1, prio1, time)	\
		CHA_FADEIN_2_XY_NW(no0, file0, pos0, SC_CHRPOS_Y, prio0, no1, file1, pos1, SC_CHRPOS_Y, prio1, time)

#define CHA_FADEIN_2(no0, file0, pos0, prio0, no1, file1, pos1, prio1, time)	\
		CHA_FADEIN_2_XY(no0, file0, pos0, SC_CHRPOS_Y, prio0, no1, file1, pos1, SC_CHRPOS_Y, prio1, time)
// ---------------------------------------------------------------------
// ３キャラをセットしてフェードイン
#define CHA_FADEIN_3_NW(no0, file0, prio0, no1, file1, prio1, no2, file2, prio2, time)	\
		Cha_Set(no0, file0)					\
		Cha_Set(no1, file1)					\
		Cha_Set(no2, file2)					\
		Cha_Pos(no0, POS0, SC_CHRPOS_Y)		\
		Cha_Pos(no1, POS2, SC_CHRPOS_Y)		\
		Cha_Pos(no2, POS4, SC_CHRPOS_Y)		\
		Cha_Priority(no0, prio0)			\
		Cha_Priority(no1, prio1)			\
		Cha_Priority(no2, prio2)			\
		Cha_FadeIn(no0, 0, time)			\
		Cha_FadeIn(no1, 0, time)			\
		Cha_FadeIn(no2, 0, time)

#define CHA_FADEIN_3(no0, file0, prio0, no1, file1, prio1, no2, file2, prio2, time)		\
		CHA_FADEIN_3_NW(no0, file0, prio0, no1, file1, prio1, no2, file2, prio2, time)	\
		Cha_Wait(no0)
// =====================================================================


// =====================================================================
// 複数キャラの同時フェードアウト
// ---------------------------------------------------------------------
// ２キャラ同時にフェードアウト
#define CHA_FADEOUT_2_NW(no0, no1, time)	\
		Cha_FadeOut(no0, 0, time)			\
		Cha_FadeOut(no1, 0, time)

#define CHA_FADEOUT_2(no0, no1, time)		\
		CHA_FADEOUT_2_NW(no0, no1, time)	\
		Cha_Wait(no0)
// ---------------------------------------------------------------------
// ３キャラ同時にフェードアウト
#define CHA_FADEOUT_3_NW(no0, no1, no2, time)	\
		Cha_FadeOut(no0, 0, time)				\
		Cha_FadeOut(no1, 0, time)				\
		Cha_FadeOut(no2, 0, time)

#define CHA_FADEOUT_3(no0, no1, no2, time)		\
		CHA_FADEOUT_3_NW(no0, no1, no2, time)	\
		Cha_Wait(no0)
// =====================================================================


// =====================================================================
// 複数キャラのクロスフェード
// ---------------------------------------------------------------------
// クロスフェード（２キャラを消しつつ２キャラ同時表示）
#define CHA_CROSS_FADE_2TO2_NW(no0, file0, pos0, prio0, no1, file1, pos1, prio1, time, out_no0, out_no1)	\
		Cha_Set(no0, file0)				\
		Cha_Set(no1, file1)				\
		Cha_Pos(no0, pos0, SC_CHRPOS_Y)	\
		Cha_Pos(no1, pos1, SC_CHRPOS_Y)	\
		Cha_Priority(no0, prio0)		\
		Cha_Priority(no1, prio1)		\
		Cha_FadeIn(no0, 0, time)		\
		Cha_FadeIn(no1, 0, time)		\
		Cha_FadeOut(out_no0, 0, time)	\
		Cha_FadeOut(out_no1, 0, time)

#define CHA_CROSS_FADE_2TO2(no0, file0, pos0, prio0, no1, file1, pos1, prio1, time, out_no0, out_no1)		\
		CHA_CROSS_FADE_2TO2_NW(no0, file0, pos0, prio0, no1, file1, pos1, prio1, time, out_no0, out_no1)	\
		Cha_Wait(no0)
// ---------------------------------------------------------------------
// クロスフェード（１キャラを消しつつ２キャラ同時表示）
#define CHA_CROSS_FADE_1TO2_NW(no0, file0, pos0, prio0, no1, file1, pos1, prio1, time, out_no)	\
		Cha_Set(no0, file0)				\
		Cha_Set(no1, file1)				\
		Cha_Pos(no0, pos0, SC_CHRPOS_Y)	\
		Cha_Pos(no1, pos1, SC_CHRPOS_Y)	\
		Cha_Priority(no0, prio0)		\
		Cha_Priority(no1, prio1)		\
		Cha_FadeIn(no0, 0, time)		\
		Cha_FadeIn(no1, 0, time)		\
		Cha_FadeOut(out_no, 0, time)

#define CHA_CROSS_FADE_1TO2(no0, file0, pos0, prio0, no1, file1, pos1, prio1, time, out_no)		\
		CHA_CROSS_FADE_1TO2_NW(no0, file0, pos0, prio0, no1, file1, pos1, prio1, time, out_no)	\
		Cha_Wait(no0)
// ---------------------------------------------------------------------
// クロスフェード（２キャラを消しつつ１キャラ表示）
#define CHA_CROSS_FADE_2TO1_NW(no, file, pos, prio, time, out_no0, out_no1)	\
		Cha_Set(no, file)				\
		Cha_Pos(no, pos, SC_CHRPOS_Y)	\
		Cha_Priority(no, prio)			\
		Cha_FadeIn(no, 0, time)			\
		Cha_FadeOut(out_no0, 0, time)	\
		Cha_FadeOut(out_no1, 0, time)

#define CHA_CROSS_FADE_2TO1(no, file, pos, prio, time, out_no0, out_no1)	\
		CHA_CROSS_FADE_2TO1_NW(no, file, pos, prio, time, out_no0, out_no1)	\
		Cha_Wait(no)
// ---------------------------------------------------------------------
// ２キャラ同時表情変え（真後ろに同じポーズのキャラを出し前のキャラをフェードアウト）
#define CHA_CHANGE_FACE_2TO2(no0, file0, pos0, prio0, no1, file1, pos1, prio1, time, out_no0, out_no1)	\
		Cha_Priority(out_no0, prio0-1)		\
		Cha_Priority(out_no1, prio1-1)		\
		CHA_SET(no0, file0, pos0, prio0)	\
		CHA_SET(no1, file1, pos1, prio1)	\
		Cha_FadeOut(out_no0, 0, time)		\
		Cha_FadeOut(out_no1, 0, time)		\
		Cha_Wait(out_no0)
// =====================================================================


// =====================================================================
// ＢＧＭ
// ---------------------------------------------------------------------
// ＢＧＭを再生
#define BGM_PLAY(file, time)	BGM_Play(0, file, 0, time)
//#define BGM_PLAY(file, time)	BGM_Play(0, file, 1, time)	// ループ無し設定で再生するとロードしたとき復帰しない

// ＢＧＭをループ再生
#define BGM_LOOP(file, time)	BGM_Play(0, file, 0, time)

// ＢＧＭを停止
#define BGM_STOP(time)			BGM_Stop(0, time)

// ＢＧＭのボリューム設定
#define BGM_VOL(vol, time)		BGM_Vol(0, vol, time)

// ＢＧＭのパンポットの設定
#define BGM_PAN(pan, time)		BGM_Pan(0, pan, time)

// ＢＧＭエフェクト終了待ち（ボリューム・パンポット等）
#define BGM_WAIT()				BGM_Wait(0)

// ＢＧＭ再生終了待ち（STOP後のウェイト）
#define BGM_ENDWAIT()			BGM_EndWait(0)
// =====================================================================


// =====================================================================
// ＳＥ
// ---------------------------------------------------------------------
// ＳＥを再生
#define SE_PLAY(no, file, time)	SE_Play(no, file, 1, time)

// ＳＥをループ再生
#define SE_LOOP(no, file, time)	SE_Play(no, file, 0, time)

// ＳＥを停止
#define SE_STOP(no, time)		SE_Stop(no, time)

// ＳＥのボリューム設定
#define SE_VOL(no, vol, time)	SE_Vol(no, vol, time)

// ＳＥのパンポットの設定
#define SE_PAN(no, pan, time)	SE_Pan(no, pan, time)

// ＳＥエフェクト終了待ち（ボリューム・パンポット等）
#define SE_WAIT(no)				SE_Wait(no)

// ＳＥ再生終了待ち（STOP後のウェイト）
#define SE_ENDWAIT(no)			SE_EndWait(no)

// ＳＥを強調再生（BGM停止後SE再生、再生終了したらBGM復帰）
#define SE_PLAY_EX(no, file, time)	\
		BGM_Vol(0, 0, 0)			\
		SE_Play(no, file, 1, 0)		\
		SE_EndWait(no)				\
		BGM_Vol(no, 100, time)
// =====================================================================

#endif	// _MACROS_H_
